/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY                          *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public Liense as published by        *
 * the Free Software Foundation, either version 2 of the License, or (at      * 
 * your option) any later version.                                            *
 *                                                                            *
 * The ITX package is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
 * for more details.                                                          * 
 *                                                                            *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.                                                   *
 *                                                                            * 
 * Contact information:                                                       *
 * Donna Bergmark                                                             *
 * 484 Rhodes Hall                                                            *
 * Cornell University                                                         *
 * Ithaca, NY 14853-3801                                                      *
 * bergmark@cs.cornell.edu                                                    *
 ******************************************************************************/


// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAINFRM_H__622ACF0B_F6E1_11D2_BAFC_0080C773B9A1__INCLUDED_)
#define AFX_MAINFRM_H__622ACF0B_F6E1_11D2_BAFC_0080C773B9A1__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "ChildView.h"
#include "CeDataSocket.h"

struct SOUNDBUFFER {
	PBYTE buffer;
	PWAVEHDR wavehdr;
	UINT length;
	BOOL used;
	UINT index;
};


class CDatagramSocket;

class CMainFrame : public CFrameWnd
{
public:
	CMainFrame();
protected: 
	DECLARE_DYNAMIC(CMainFrame)

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
	virtual BOOL DestroyWindow();
	//}}AFX_VIRTUAL
	void ReceivedData(); // when we get voice packets, this function is called

// Implementation
public:
	void ReceivedCommand(); // 
	virtual ~CMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	CCeCommandBar	m_wndCommandBar;
	CStatusBar		m_wndStatusBar;
	CChildView    m_wndView;
	BOOL	m_bRecording;
	BOOL	m_bPlaying;
	BOOL	m_bShutoff;
	HWAVEOUT m_hWaveOut;
	HWAVEIN	m_hWaveIn;
	SOUNDBUFFER* OutBuffers;
	SOUNDBUFFER* InBuffers;
	BOOL m_bBIn1Free, m_bBIn2Free;
//	CCeServerSocket *m_ccss;
//	CCeDataSocket *m_ccds;
	CDatagramSocket *m_pDataSock;
	PWAVEHDR m_pWaveHdrIn1, m_pWaveHdrIn2;

// Generated message map functions
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSetFocus(CWnd *pOldWnd);
	afx_msg LRESULT OnWaveOutOpen(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnWaveOutClose(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnWaveOutDone(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnWaveInOpen(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnWaveInData(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnWaveInClose(WPARAM wParam, LPARAM lParam);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnDisconnect();
	afx_msg void OnConnect();
	afx_msg void OnUpdateConnect(CCmdUI* pCmdUI);
	afx_msg void OnUpdateDisconnect(CCmdUI* pCmdUI);
	afx_msg void OnPhoneCall();
	afx_msg void OnPhoneHangup();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	HANDLE m_pWaveFile;
	CCeDataSocket* m_pSignalSocket;
	UINT m_nNumPlaying;
	int m_nBufferNum;
	BOOL m_bWaveOutOpened;
	int m_nNumBytesDropped;
	int m_nNumBytesReceived;
	friend unsigned int AFX_CDECL SenderThread( LPVOID pvParams );
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINFRM_H__622ACF0B_F6E1_11D2_BAFC_0080C773B9A1__INCLUDED_)
